import React from 'react';

const Field = ({ type, name, placeholder, options, mandatory, minlength, onChange, value, maxEntries = 1, label ="" }) => {
    const handleChange = (e, index = 0) => {
        if (Array.isArray(value)) {
            const newValue = [...value];
            newValue[index] = e.target.value;
            onChange(name, newValue);
        } else {
            onChange(name, e.target.value);
        }
    };

    if (Array.isArray(value) && type !== 'select') {
        return value.map((val, index) => (
            <div key={index}>
                <input 
                    type={type} 
                    placeholder={placeholder} 
                    value={val} 
                    onChange={(e) => handleChange(e, index)}
                    required={mandatory} 
                    minLength={minlength} 
                />
                {index < maxEntries - 1 && (
                    <button onClick={() => {
                        const newValue = [...value];
                        newValue.push('');
                        onChange(name, newValue);
                    }}>Add Another</button>
                )}
            </div>
        ));
    }

    switch (type) {
        case 'select':
            return (
                <select name={name} onChange={(e) => handleChange(e)} value={value} required={mandatory}>
                    <option value="">{placeholder}</option>
                    {options.map(opt => (
                        <option key={opt.value} value={opt.value}>
                            {opt.label}
                        </option>
                    ))}
                </select>
            );
        case 'email':
            return (
                <input 
                    type="email" 
                    name={name} 
                    placeholder={placeholder} 
                    onChange={(e) => handleChange(e)} 
                    value={value} 
                    required={mandatory} 
                    minLength={minlength} 
                    pattern="[a-z0-9._%+-]+@[a-z0-9.-]+\.[a-z]{2,}$" 
                />
            );
        
        default:
            return (
                <input 
                    type={type} 
                    name={name} 
                    placeholder={placeholder} 
                    onChange={(e) => handleChange(e)} 
                    value={value} 
                    required={mandatory} 
                    minLength={minlength} 
                />
            );
    }
};

export default Field;
